from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj, remove_self_loops
from torch_geometric.nn.inits import reset, glorot, zeros
from sklearn.decomposition import PCA
from filling_strategies import filling
import pickle
from tqdm import tqdm, trange
import time
from torch_geometric.utils.undirected import to_undirected, is_undirected

class GOODIE_2():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            
            filled_features_fp = filling('fp', self.edge_index, self.x, self.missing_feature_mask, self.args.num_iterations)
            self.x = torch.where(self.missing_feature_mask, self.x, filled_features_fp)

            # Obtain Pseudo Labels
            lp_output = self.lp_mat.to(self.args.device)
            self.pseudo_labels = lp_output.argmax(1)
           
            lp_prediction = torch.softmax(lp_output / self.args.lp_temp, 1).max(1)[0]
            lp_prediction[self.train_mask] = 1.0
            
            # Leveraging partial labels
            self.edge_weight=None

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)
            include_neighbors = self.args.include_neighbors

            acc_vals = []
            test_results = []
            best_metric = 0

            for epoch in range(0, self.args.epochs):
                start_time = time.time()
                model.train()

                if self.train_loader:
                    # print('Start Training...')
                    total_loss = 0
                    idx = 0
                    train_batch_iter = tqdm(enumerate(self.train_loader), total=len(self.train_loader))
                    for i, (batch_size, n_id, _adjs) in train_batch_iter:
                        optimizer.zero_grad()
                        idx += 1
                        # `adjs` holds a list of `(edge_index, e_id, size)` tuples.
                        # if include_neighbors:
                        #     _adjs[0] = to_undirected(_adjs[0])

                        adjs = [(_adjs[0].to(self.args.device), _adjs[1].to(self.args.device), _adjs[2])]
                        x_batch = self.x[n_id] # self + one-hop neighbors.
                        lp_batch = lp_output[n_id] # self + one-hop neighbors.
                        
                        _fp_embed = model.classifier1(x_batch, adjs, self.edge_weight, embed=True, sample=True, include_neighbors=include_neighbors) # 1024 x 64
                        _lp_embed = model.classifier2(lp_batch, adjs, self.edge_weight, embed=True, sample=True, include_neighbors=include_neighbors) # 1024 x 64

                        fp_ = model.leakyrelu(torch.mm(_fp_embed, model.attention))
                        lp_ = model.leakyrelu(torch.mm(_lp_embed, model.attention))
                        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
                        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
                        # output_ = _lp_embed

                        loss_con = 0

                        if self.args.lamb != 0.0:
                            centroids = torch.rand((self.args.n_class, output_.shape[1])).to(output_.device)                            
                            if include_neighbors:
                                label_idx = self.pseudo_labels[n_id]
                                lp_ = lp_prediction[n_id]
                                
                            else:
                                label_idx = self.pseudo_labels[n_id[:batch_size]]
                                lp_ = lp_prediction[n_id[:batch_size]]
                            
                            # # class version (GOODIE 2)
                            # label_mat = torch.nn.functional.one_hot(label_idx).T + 0.0
                            # # normalize label_mat
                            # if self.args.normalize_label_mat:
                            #     label_mat = label_mat / label_mat.sum(1).unsqueeze(1)
                            #     label_mat = torch.nan_to_num(label_mat, 0.0)
                        
                            # centroids = (torch.mm(torch.mm(label_mat, torch.diag(lp_)), output_))
                            # loss_con = model.pseudocon_loss(centroids, scaled=True)

                            # class version (GOODIE 2) - only consider target loss when include_negibors == True
                            # label_mat = torch.nn.functional.one_hot(label_idx[:batch_size]).T + 0.0
                            # # normalize label_mat
                            # if self.args.normalize_label_mat:
                            #     label_mat = label_mat / label_mat.sum(1).unsqueeze(1)
                            #     label_mat = torch.nan_to_num(label_mat, 0.0)
                        
                            # centroids = (torch.mm(torch.mm(label_mat, torch.diag(lp_[:batch_size])), output_[:batch_size]))
                            # loss_con = model.pseudocon_loss(centroids, scaled=True)

                            ## batch version (GOODIE 1)
                            loss_con = model.pseudocon_loss(output_, label_idx, weight_mask=lp_)     
                            
                            ## batch version (GOODIE 1) - only consider target loss when include_negibors == True                      
                            # loss_con = model.pseudocon_loss(output_[:batch_size], label_idx[:batch_size], weight_mask=lp_[:batch_size])                            

                        if include_neighbors:
                            y_pred = model.classifier3(output_, adjs, self.edge_weight, sample=True) # self w/ one-hop -> self
                        else:
                            # y_pred = model.classifier3(output_, adjs, self.edge_weight, sample=True) # self w/ one-hop -> self
                            y_pred = model.classifier3.classifier(output_)
                        
                        y_true = self.labels[n_id[:batch_size]].squeeze()
                        loss_ce = F.cross_entropy(y_pred, y_true)

                        loss = loss_ce + self.args.lamb * loss_con
                        # loss = loss_con

                        loss.backward()
                        optimizer.step()
                        total_loss += loss.item()

                else:
                    optimizer.zero_grad()

                    loss_ce, loss_con = model(self.x, lp_output, self.edge_index, self.edge_weight, self.labels, self.pseudo_labels, self.train_mask, weight_mask=lp_prediction)
                    loss = loss_ce + self.args.lamb * loss_con

                    loss.backward()
                    optimizer.step()

                # Valid
                model.eval()
                if self.inference_loader:
                    # print('Start Evaluation...')
                    total_edges = 0
                    x_tmp = deepcopy(self.x.cpu())
                    lp_tmp = deepcopy(lp_output.cpu())
                    xs = []
                    inference_batch_iter = tqdm(enumerate(self.inference_loader), total=len(self.inference_loader))
                    for i, (batch_size, n_id, adj) in inference_batch_iter:
                        edge_index, _, size = adj.to(self.args.device) # all neighbors
                        total_edges += edge_index.size(1)
                        x = x_tmp[n_id].to(self.args.device)
                        x_target = x[: size[1]]
                        lp = lp_tmp[n_id].to(self.args.device)
                        lp_target = lp[: size[1]]
                        
                        if include_neighbors:
                            x_target = x
                            lp_target = lp

                        _fp_embed = F.relu(model.classifier1.conv1[0]((x, x_target), edge_index))
                        _lp_embed = F.relu(model.classifier2.conv1[0]((lp, lp_target), edge_index))

                        fp_ = model.leakyrelu(torch.mm(_fp_embed, model.attention))
                        lp_ = model.leakyrelu(torch.mm(_lp_embed, model.attention))
                        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
                        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
                    
                        if include_neighbors:
                            x = F.relu(model.classifier3.conv1[0](output_, edge_index)) # 여기 확인해봐야함.
                            x = model.classifier3.classifier(x[:size[1]]) # remain only targets
                        else:
                            # 여기 확인해봐야함.
                            x = model.classifier3.classifier(output_)

                        xs.append(x.detach().cpu())

                    output = torch.cat(xs, dim=0)

                else:
                    fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                    lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                            
                    fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                    lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                    values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                    output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                    output = model.classifier3(output_, self.edge_index, self.edge_weight)

                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric < acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    loss_ce = loss_ce.item() if loss_ce != 0 else loss_ce
                    loss_con = loss_con.item() if loss_con != 0 else loss_con
                    st = "CE loss: {:.2f} | Pseudo loss: {:.2f}\n".format(loss_ce, loss_con)
                    st += "[seed {}][{}-{}][{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "Time Spent: {:.2f}s per epoch\n".format((time.time() - start_time))
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
  
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break

            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info(self.args)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier1 = GCN(1, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            classifier2 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            classifier3 = GCN(1, args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier1 = SAGE(1, args.n_feat, args.n_hid, args.n_class)
            classifier2 = SAGE(1, args.n_class, args.n_hid, args.n_class)
            classifier3 = SAGE(1, args.n_hid, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier1 = classifier1
        self.classifier2 = classifier2
        self.classifier3 = classifier3
        self.leakyrelu = nn.LeakyReLU(args.leaky_alpha)
        self.attention = nn.Parameter(torch.empty(size=(args.n_hid, 1)))
        glorot(self.attention)

    def forward(self, x, lp_embed, edge_index, edge_weight, labels, pseudo_labels, idx_train, weight_mask=None, batch=False):
        _fp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        _lp_embed = self.classifier2(lp_embed, edge_index, edge_weight, embed=True)

        fp_ = self.leakyrelu(torch.mm(_fp_embed, self.attention))
        lp_ = self.leakyrelu(torch.mm(_lp_embed, self.attention))
        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
        
        sup_con_loss = 0
        
        if self.args.lamb != 0.0:
            centroids = torch.empty((self.args.n_class, output_.shape[1])).to(output_.device)
            for i in range(self.args.n_class):
                idx = pseudo_labels == i
                centroids[i, :] = (output_[idx] * weight_mask[idx].unsqueeze(1)).mean(0)
                # centroids[i, :] = (output_[idx]).mean(0)
            sup_con_loss = self.pseudocon_loss(centroids, scaled=True)

        output = self.classifier3(output_, edge_index, edge_weight)

        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])
        
        return loss_nodeclassification, sup_con_loss

    def pseudocon_loss(self, features, labels=None, mask=None, temp=0.07, base_temp=0.07, weight_mask=None, scaled=False):
        # Normalize
        features = F.normalize(features, dim=-1)
        batch_size = features.shape[0]
        if scaled:
            mask = torch.eye(batch_size, dtype=torch.float32).to(self.args.device)
        else:
            labels = labels.contiguous().view(-1, 1)
            mask = torch.eq(labels, labels.T).float()

        # compute logits
        anchor_dot_contrast = torch.div(
            torch.matmul(features, features.T),
            self.args.temp)
        # for numerical stability
        logits_max, _ = torch.max(anchor_dot_contrast, dim=1, keepdim=True)
        logits = anchor_dot_contrast - logits_max.detach()

        # tile mask
        # mask-out self-contrast cases
        logits_mask = torch.scatter(
            torch.ones_like(mask),
            1,
            torch.arange(batch_size).view(-1, 1).to(self.args.device),
            0
        )
        mask = mask * logits_mask

        # compute log_prob
        exp_logits = torch.exp(logits) * logits_mask 
        log_prob = logits - torch.log(exp_logits.sum(1, keepdim=True))

        if scaled:
            mean_log_prob_pos = log_prob.sum(1)
        else:
            row_mask = mask.sum(1) != 0 
            mean_log_prob_pos = (weight_mask[row_mask].unsqueeze(1) * mask[row_mask] * log_prob[row_mask]).sum(1) / mask[row_mask].sum(1)

        loss = - (temp / base_temp) * mean_log_prob_pos
        loss = loss.mean()

        return loss



        # conda activate py37

        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat False --gpu 1
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat True --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat False --gpu 3
        
        # python main.py --dataset OGBN-Mag --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat False --gpu 5
        # python main.py --dataset OGBN-Mag --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat True --gpu 6
        # python main.py --dataset OGBN-Mag --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat False --gpu 7


        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 0
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat False --gpu 1
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat True --gpu 2
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat False --gpu 3
        
        # python main.py --dataset OGBN-Products --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 4
        # python main.py --dataset OGBN-Products --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors True --normalize_label_mat False --gpu 5
        # python main.py --dataset OGBN-Products --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat True --gpu 6
        # python main.py --dataset OGBN-Products --missing_rate 1.0 --lamb 0.01 --n_runs 1 --include_neighbors False --normalize_label_mat False --gpu 7



        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-9 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-8 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 1
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-7 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-6 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 3


        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-13 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-12 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 5
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-11 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 6
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-10 --n_runs 1 --include_neighbors True --normalize_label_mat True --gpu 7


        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-1 --n_runs 1 --include_neighbors True --normalize_label_mat True --batch_size 512 --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-1 --n_runs 1 --include_neighbors True --normalize_label_mat True --batch_size 1024 --gpu 3
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-1 --n_runs 1 --include_neighbors True --normalize_label_mat True --batch_size 2048 --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-1 --n_runs 1 --include_neighbors True --normalize_label_mat True --batch_size 4096 --gpu 5
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-1 --n_runs 1 --include_neighbors True --normalize_label_mat True --batch_size 512 --gpu 6

        # ============ alpha selection ============ #
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.6 --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.7 --gpu 1
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.8 --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.9 --gpu 3
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.99 --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.999 --gpu 5

        # ============ lamb selection ============ #        
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-5 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --n_runs 1 --gpu 1
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-3 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-2 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-1 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 0.0 --n_runs 1 --gpu 5

        # ============ batch_size selection ============ #
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 512 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --n_runs 1 --gpu 1 
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 2048 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 4096 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 8192 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 16384 --n_runs 1 --gpu 5

        # ============ temp selection ============ #
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.0001 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.001 --n_runs 1 --gpu 1 
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.01 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.1 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 1 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Mag --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 10 --n_runs 1 --gpu 5



        # ============ alpha selection ============ #
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.6 --gpu 0
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.7 --gpu 1
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.8 --gpu 2
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.9 --gpu 3
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.99 --gpu 4
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lamb 1e-5 --n_runs 1 --lp_alpha 0.999 --gpu 5

        # ============ lamb selection ============ #        
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-5 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --n_runs 1 --gpu 1
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-3 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-2 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-1 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 0.0 --n_runs 1 --gpu 5

        # ============ batch_size selection ============ #
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 512 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --n_runs 1 --gpu 1 
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 2048 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 4096 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 8192 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 16384 --n_runs 1 --gpu 5

        # ============ temp selection ============ #
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.0001 --n_runs 1 --gpu 0
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.001 --n_runs 1 --gpu 1 
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.01 --n_runs 1 --gpu 2
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 0.1 --n_runs 1 --gpu 3
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 1 --n_runs 1 --gpu 4
        # python main.py --dataset OGBN-Products --missing_rate 0.0 --lp_alpha 0.999 --lamb 1e-4 --batch_size 1024 --temp 10 --n_runs 1 --gpu 5